% TechnologyInfusionInterface2.m
% by Darren Chang (darrenz@mit.edu)
% last modified: 8/11/03

function [addSCMass,addChannelFactor,addDVCost,addFUCost,newTech,beamManage] = ...
    TechnologyInfusionInterface2(TIIoption,GT_dB,cellDuration,cellNumber,DSatT,totBW_downlink,wavelength,...
    addSCMass,addChannelFactor,addDVCost,addFUCost,newTech)

% Must use digital/analog beam forming technology if 
% the cell duration is less than 30 seconds

Mass = 0;
ChannelFactor = 1;
DVCost = 0;
FUCost = 0;
if TIIoption(4) == 1                            % DBF/ABF is selected
    newTech = strcat(newTech,'DBF/ABF.');
    
    % DBF.m
% Digital/Analog Beam Forming    
% Darren Chang (darrenz@mit.edu)
% last modified: 8/8/02

% ISL,cellNumber,freq,totBW_downlink

% 0.3-m of antenna size and 10MHz of link bandwidth
% are used to judge if DBF or ABF can be used.
if DSatT >= 0.3 & totBW_downlink <= 10
    DBF = 1;        % use DBF, not ABF
    ABF = 0;
elseif DSatT < 0.3 & totBW_downlink <= 10
    DBF = 0;        % use ABF, not DBF
    ABF = 1;
elseif DSatT >= 0.3 & totBW_downlink > 10
    DBF = 0;        % Only ABF can be used although it's not ideal.
    ABF = 1;
elseif DSatT < 0.3 & totBW_downlink > 10
    DBF = 0;        % use ABF, not DBF
    ABF = 1;
end;

if DBF == 1
    Nelement      = (DSatT/wavelength)^2;
    NUPconverter  = Nelement;
    Ncalculator   = ceil(NUPconverter/20);
    Ncontroller   = 1;
    Nfrontend     = 1;
    NSSPA         = Nelement;
    Nheater       = Nelement/10;
    Nintegration  = 1;
    
    CUPconverter = NUPconverter*1.695;  % [K$]
    Ccalculator  = Ncalculator*423.729;
    Ccontroller  = Ncontroller*338.983;
    Cfrontend    = Nfrontend*338.983;
    CSSPA        = NSSPA*1.695;
    Celement     = Nelement*0.847;
    Cheater      = Nheater*2.542;
    Cintegration = Nintegration*338.983;
    
    DBF_FUCost = CUPconverter + Ccalculator + Ccontroller + Cfrontend + CSSPA + Celement + Cheater + Cintegration;
    DBF_DVCost = 2*DBF_FUCost;
elseif ABF == 1
    Nelement      = (DSatT/wavelength)^2;
    NUPconverter  = cellNumber;
    Ncontroller   = 1;
    NBFN          = NUPconverter/10;
    NSSPA         = Nelement;
    Nheater       = Nelement/10;
    Nintegration  = 1;
    
    CUPconverter = NUPconverter*1.695;  % [K$]
    Ccontroller  = Ncontroller*338.983;
    CBFN         = NBFN*338.983;
    CSSPA        = NSSPA*1.695;
    Celement     = Nelement*0.847;
    Cheater      = Nheater*2.542;
    Cintegration = Nintegration*338.983;
    
    DBF_FUCost = CUPconverter + Ccontroller + CBFN + CSSPA + Celement + Cheater + Cintegration;
    DBF_DVCost = 2*DBF_FUCost;
end;
    
    

DBF_unit = 1;
DBF_mass = 0;             % [kg]
DBF_ChannelFactor = 1;    % [-]

Mass    = DBF_mass*DBF_unit;     
ChannelFactor = DBF_ChannelFactor;
DVCost = DBF_DVCost;
FUCost = DBF_FUCost*DBF_unit;
    
    
    beamManage = 1;
elseif TIIoption(4) == 0 & cellDuration < 30    % DBF/ABF needed but not selected
    beamManage = 0;
else                                            % DBF/ABF not needed and not selected
    beamManage = 1;
end;
addSCMass  = addSCMass + Mass;
addChannelFactor = addChannelFactor*ChannelFactor;
addDVCost  = addDVCost + DVCost;
addFUCost  = addFUCost + FUCost;